#include <bits/stdc++.h>
using namespace std;
#define MAX 80000
#define log 20 // log2(MAX)
int level[MAX];
int lca[MAX][log];
int dist[MAX][log];
vector<pair<int, int> > graph[MAX];
void addEdge(int u, int v, int cost)
{
    graph[u].push_back({ v, cost });
    graph[v].push_back({ u, cost });
}
void dfs(int node, int parent, int h, int cost)
{
    lca[node][0] = parent;
    level[node] = h;
    if (parent != 0) dist[node][0] = cost;
    for (int i = 1; i < log; i++) {
        if (lca[node][i - 1] != 0) {
            lca[node][i] = lca[lca[node][i - 1]][i - 1];
            dist[node][i] = dist[node][i - 1] + dist[lca[node][i - 1]][i - 1];
        }
    }
    for (auto i : graph[node]) {
        if (i.first == parent)
            continue;
        dfs(i.first, node, h + 1, i.second);
    }
}
int findDistance(int u, int v)
{
    int ans = 0;
    if (level[u] > level[v]) swap(u, v);
    for (int i = log - 1; i >= 0; i--) {
        if (lca[v][i] != 0 && level[lca[v][i]] >= level[u]) {
            ans += dist[v][i];
            v = lca[v][i];
        }
    }
    if (v == u) return ans;
    else {
        for (int i = log - 1; i >= 0; i--) {
            if (lca[v][i] != lca[u][i]) {
                ans += dist[u][i] + dist[v][i];
                v = lca[v][i];
                u = lca[u][i];
            }
        }
        ans += dist[u][0] + dist[v][0];
        return ans;
    }
}

int main()
{
    int n;
    cin>>n;
    vector<int> p(n+1), v(n+1), s(n+1);
    for(int i=1; i<=n; i++){
        cin>>p[i];
        v[i]=p[i];
    }
    /*for(int i=1; i<=n; i++){
        s[i]=i;
    }*/
    for(int i=1; i<n; i++){
        int a, b;
        cin>>a>>b;
        addEdge(a, b, 1);
    }
    dfs(1, 0, 0, 0);
    //cout<<findDistance(5, 3);
    int q;
    cin>>q;
    int l, r, x, ind;
    while(q--){
        cin>>ind;
        if(ind==1){
            cin>>l>>r;
            swap(p[l], p[r]);
            //swap(s[p[l]], s[p[r]]);
            /*for(int i=1; i<=n; i++) cout<<p[i]<<' ';
            cout<<endl;*/
        }
        else{
            cin>>l>>r>>x;
            int m=0;
            //x=s[x];
            //cout<<x<<endl;
            for(int i=l; i<=r; i++){
                //cout<<findDistance(x, p[i])<<endl;
                m=max(m, findDistance(x, p[i]));
            }
            cout<<m<<endl;
        }
    }
    //for(int i=1; i<=n; i++) cout<<s[i]<<' ';
}